using System;
using Borland.Eco.Services;
using Borland.Eco.UmlCodeAttributes;

namespace AssociationClassDemo
{
	[EcoSpace]
	[EcoSpacePackage(typeof(AssociationClassDemo.CoreClassesPackage))]
	public class AssociationClassDemoEcoSpace: Borland.Eco.Handles.DefaultEcoSpace
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private void InitializeComponent()
		{
		}

		public AssociationClassDemoEcoSpace(): base()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				Active = false;
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		private static ITypeSystemService m_TypeSystemProvider;
		public static new ITypeSystemService GetTypeSystemService()
		{
		if (m_TypeSystemProvider == null)
				lock(typeof(AssociationClassDemoEcoSpace))
				{
					if (m_TypeSystemProvider == null)
						m_TypeSystemProvider = MakeTypeService(typeof(AssociationClassDemoEcoSpace));
				}
			return m_TypeSystemProvider;
		}
		protected override ITypeSystemService GetTypeSystemProvider()
		{
			return AssociationClassDemoEcoSpace.GetTypeSystemService();
		}
		//
		// Services
		//
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)GetEcoService(typeof(IDirtyListService)); }
		}
		public IUndoService UndoService
		{
			get { return (IUndoService)GetEcoService(typeof(IUndoService)); }
		}
		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService)); }
		}
		//
		// Misc helper functions
		//
		public void UpdateDatabase()
		{
			if ((PersistenceService != null) && (DirtyListService != null))
			{
				PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
			}
		}
		//
		// Add user written methods here
		//
	}
}
